{ DemoHiEd: Main form
  Copyright (c) 1997 by Skylark Software
  All rights reserved. }

unit DemoHiEd;

interface

uses
  Forms, StdCtrls, Controls, Classes, Graphics;

type
  TfrmHiEditDemo = class(TForm)
    gbSamples: TGroupBox;
    gbColors: TGroupBox;
    lblActClr1: TLabel;
    cbLblClr1: TComboBox;
    cbLblClr2: TComboBox;
    lblActClr2: TLabel;
    cbLblClr3: TComboBox;
    lblActClr3: TLabel;
    cbEditClr1: TComboBox;
    cbEditClr2: TComboBox;
    cbEditClr3: TComboBox;
    lblLabels: TLabel;
    lblEdits: TLabel;
    lblComp1: TLabel;
    lblComp2: TLabel;
    lblComp3: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure DoLabelColorChange(Sender: TObject);
    procedure DoEditColorChange(Sender: TObject);
  private
    { Private declarations }
    procedure BuildColors(const S: string);
  public
    { Public declarations }
  end;

var
  frmHiEditDemo: TfrmHiEditDemo;

implementation

{$R *.DFM}

uses DsgnIntf, HiEdit;

procedure TfrmHiEditDemo.FormCreate(Sender: TObject);

  procedure createEdit(lbl: TLabel; cb: TComboBox);
  begin
    cb.Tag := LongInt(TSSHiEdit.Create(Self));
    with TSSHiEdit(cb.Tag) do
      begin
        Width := cb.Width;
        Height := cb.Height;
        Top := lbl.Top + ((lbl.Height-cb.Height) div 2);
        Parent := gbSamples;
        LabelChange := TLabel.Create(Self);
        with TLabel(LabelChange) do
          begin
            Left := lbl.Left + lbl.Width + 8;
            Height := cb.Height;
            Top := lbl.Top;
            Caption := 'Test label';
            Parent := gbSamples;
          end;
        LabelFont := cb.Font;
        Left := TLabel(LabelChange).Left + TLabel(LabelChange).Width + 16;
        with LabelFont do
            Style := Style + [fsBold];
      end;
  end;

  procedure setColorList(cb: TComboBox; const clr: String);
  begin
    with cb do
      begin
        Items := cbLblClr1.Items;
        ItemIndex := Items.IndexOf(clr);
        cb.OnChange(cb);
      end;
  end;

begin
  createEdit(lblComp1, cbLblClr1); cbEditClr1.Tag := cbLblClr1.Tag;
  createEdit(lblComp2, cbLblClr2); cbEditClr2.Tag := cbLblClr2.Tag;
  createEdit(lblComp3, cbLblClr3); cbEditClr3.Tag := cbLblClr3.Tag;

  with TColorProperty.Create do
    try
      GetValues(BuildColors);
    finally
      Free;
    end;

  with cbLblClr1 do
    begin
      ItemIndex := Items.IndexOf('clRed');
      OnChange(cbLblClr1);
    end;
  setColorList(cbLblClr2, 'clNavy');
  setColorList(cbLblClr3, 'clGreen');

  setColorList(cbEditClr1, 'clYellow');
  setColorList(cbEditClr2, 'clAqua');
  setColorList(cbEditClr3, 'clLime');
end;

procedure TfrmHiEditDemo.BuildColors(const S: string);
begin
  cbLblClr1.Items.Add(S);
end;

procedure TfrmHiEditDemo.DoLabelColorChange(Sender: TObject);
begin
  with TSSHiEdit(TComponent(Sender).Tag) do
      with TComboBox(Sender), LabelFont do
          Color := StringToColor(Items[ItemIndex]);
end;

procedure TfrmHiEditDemo.DoEditColorChange(Sender: TObject);
begin
  with TSSHiEdit(TComponent(Sender).Tag) do
      with TComboBox(Sender) do
          ColorWhenActive := StringToColor(Items[ItemIndex]);
end;

end.
